/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, Level world, BlockPos pos, IProbeConfig config) {
        ArrayList<Object> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || (Integer)Config.showSmallChestContentsWithoutSneaking.get() <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(world.m_8055_(pos).m_60734_().getRegistryName())) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if ((Integer)Config.showSmallChestContentsWithoutSneaking.get() > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= (Integer)Config.showSmallChestContentsWithoutSneaking.get()) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(world.m_8055_(pos).m_60734_().getRegistryName())) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<ItemStack>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Tools.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= (Integer)Config.showItemDetailThresshold.get();
                ChestInfoTools.showChestContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    private static void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.m_41720_())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.m_41769_(stack.m_41613_());
                return;
            }
        }
        stacks.add(stack.m_41777_());
        if (foundItems != null) {
            foundItems.add(stack.m_41720_());
        }
    }

    private static void showChestContents(IProbeInfo probeInfo, Level world, BlockPos pos, List<ItemStack> stacks, boolean detailed) {
        int rows = 0;
        int idx = 0;
        IProbeInfo horizontal = null;
        IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.chestContentsBorderColor).spacing(0));
        if (detailed) {
            for (ItemStack stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(CompoundText.create().info(stackInSlot.m_41778_()));
            }
        } else {
            for (ItemStack stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getChestContents(Level world, BlockPos pos, List<ItemStack> stacks) {
        BlockEntity te = world.m_7702_(pos);
        HashSet<Item> foundItems = (Boolean)Config.compactEqualStacks.get() != false ? new HashSet<Item>() : null;
        AtomicInteger maxSlots = new AtomicInteger();
        try {
            if (te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(capability -> {
                    maxSlots.set(capability.getSlots());
                    for (int i = 0; i < maxSlots.get(); ++i) {
                        ChestInfoTools.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                    }
                });
            } else if (te instanceof Container) {
                Container inventory = (Container)te;
                maxSlots.set(inventory.m_6643_());
                for (int i = 0; i < maxSlots.get(); ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, inventory.m_8020_(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + world.m_8055_(pos).m_60734_().getRegistryName() + " (" + te.getClass().getName() + ")", e);
        }
        return maxSlots.get();
    }
}

